
///////////////////////////////////////////////////////////////////////////////
//
//   ROCKWELL SEMICONDUCTOR SYSTEMS - COMMERCIAL GPS BUSINESS
//
///////////////////////////////////////////////////////////////////////////////
//
//
//   MSG1213.C - Message 1213 Processing
// 
//
//   DESCRIPTION
//
//   Functions to decode, build, and display Zodiac 1213 messages.
//
//
//   REVISION HISTORY
//
//   $Log:   V:\Projects\Labmon\Source\Archives\MSG1213.C_V  $
//   
//      Rev 1.15   09 Nov 1998 10:47:58   phungh
//   labmon51: Fix file logging and missing
//   logged data bugs.  Changes made to the 
//   "Pause" variable ( 1 -> 0 ) to allow main
//   loop continue.  Move the "write to file"
//   code portion out of the interrupt handler
//   so that data is not missed because of time
//   spent too long in the interrupt handler
//   
//      Rev 1.3   Jul 09 1997 10:47:32   COLEJ
//    
//   
//      Rev 1.2   Feb 12 1997 16:05:36   COLEJ
//    
//   
//      Rev 1.1   Aug 13 1996 13:50:04   COLEJ
//    
//   
//      Rev 1.0   13 May 1996 14:53:06   GPSADMIN
//   Initial release to version control.
//
//
////////////////////////////////////////////////////////////////////////////////

#include <string.h>

#include "gentypes.h"
#include "gencons.h"
#include "ztypes.h"
#include "zcons.h"
#include "util.h"  

////////////////////////////////////////////////////////////////////////////////
//   
//   Decode a Zodiac 1213 message from the ZMsgBuf.
//
void Dec1213(tMSGBUF *ZMsgBuf, tMSG1213 *Msg)
{

}

////////////////////////////////////////////////////////////////////////////////
//   
//   Build a Zodiac 1213 message in the ZMsgBuf. 
//
void Bld1213(tMSGBUF *ZMsgBuf, tMSG1213 *Msg)
{
   // copy message into buffer
   memcpy(((tSHORT *) ZMsgBuf)+5, Msg, sizeof(*Msg));          

   // build the header in the buffer
   PutShort  (0x81FF                    , ZMsgBuf, 1);    // message preamble
   PutShort  (1213                      , ZMsgBuf, 2);    // message number
   PutShort  (4                         , ZMsgBuf, 3);    // message length 
   PutShort  (ANREQ                     , ZMsgBuf, 4);    // message ack/nack request
}
